import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/css/app.css',
                'resources/js/app.js',
            ],
            refresh: true,
        }),
    ],
    build: {
        rollupOptions: {
            external: [
                '@ledgerhq/hw-transport-webusb',
                '@ledgerhq/hw-app-eth',
                '@trezor/connect-web',
            ],
        },
    },
});
