<?php

use App\Domain\Payment\Models\PaymentWithdrawal;
use App\Domain\Payment\Workflow\Activities\CompleteWithdrawalActivity;
use Illuminate\Support\Str;

it('can complete a withdrawal through activity', function () {
    $withdrawalUuid = Str::uuid()->toString();
    $transactionId = 'wtxn_' . uniqid();

    // Create a withdrawal event first
    PaymentWithdrawal::create([
        'aggregate_uuid'    => $withdrawalUuid,
        'aggregate_version' => 1,
        'event_version'     => 1,
        'event_class'       => 'withdrawal_initiated',
        'event_properties'  => json_encode([
            'accountUuid'       => Str::uuid()->toString(),
            'amount'            => 5000,
            'currency'          => 'USD',
            'reference'         => 'WD-123',
            'bankAccountNumber' => '****1234',
            'bankRoutingNumber' => '123456789',
            'bankAccountName'   => 'John Doe',
            'metadata'          => [],
        ]),
        'meta_data' => json_encode([
            'aggregate_uuid' => $withdrawalUuid,
        ]),
        'created_at' => now(),
    ]);

    $input = [
        'withdrawal_uuid' => $withdrawalUuid,
        'transaction_id'  => $transactionId,
    ];

    $activity = new class () extends CompleteWithdrawalActivity {
        public function __construct()
        {
            // Override constructor
        }
    };

    $result = $activity->execute($input);

    expect($result)->toHaveKey('withdrawal_uuid');
    expect($result)->toHaveKey('status');
    expect($result)->toHaveKey('transaction_id');
    expect($result['withdrawal_uuid'])->toBe($withdrawalUuid);
    expect($result['status'])->toBe('completed');
    expect($result['transaction_id'])->toBe($transactionId);

    // Verify the event was recorded
    $events = PaymentWithdrawal::where('aggregate_uuid', $withdrawalUuid)
        ->where('event_class', 'withdrawal_completed')
        ->get();

    expect($events)->toHaveCount(1);
});
