<?php

declare(strict_types=1);

use App\Domain\Account\Workflows\DestroyAccountWorkflow;
use Workflow\WorkflowStub;

it('can create workflow stub for destroy', function () {
    expect((new ReflectionClass(DestroyAccountWorkflow::class))->getName())->not->toBeEmpty();

    $workflow = WorkflowStub::make(DestroyAccountWorkflow::class);
    expect($workflow)->toBeInstanceOf(WorkflowStub::class);
});

it('has execute method with correct signature', function () {
    $reflection = new ReflectionClass(DestroyAccountWorkflow::class);
    $method = $reflection->getMethod('execute');

    expect($method->isPublic())->toBeTrue();
    expect($method->getNumberOfParameters())->toBe(1);
    expect($method->getReturnType()?->getName())->toBe('Generator');
});

it('extends workflow base class', function () {
    $reflection = new ReflectionClass(DestroyAccountWorkflow::class);
    expect($reflection->getParentClass()->getName())->toBe('Workflow\Workflow');
});

it('has correct parameter types', function () {
    $reflection = new ReflectionClass(DestroyAccountWorkflow::class);
    $method = $reflection->getMethod('execute');
    $parameters = $method->getParameters();

    expect($parameters[0]->getName())->toBe('uuid');

    // Check parameter type
    expect($parameters[0]->getType()?->getName())->toBe('App\Domain\Account\DataObjects\AccountUuid');
});
