<x-guest-layout>
    <div class="bg-white">
        <!-- Header -->
        <div class="bg-gray-50 border-b">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
                <h1 class="text-4xl font-bold text-gray-900">Privacy Policy</h1>
                <p class="mt-4 text-lg text-gray-600">Last updated: December 23, 2025</p>
            </div>
        </div>

        <!-- Content -->
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="prose prose-lg max-w-none">
                
                <h2>1. Introduction</h2>
                <p>{{ config('brand.legal_entity') }} ("we," "our," or "us") is committed to protecting your privacy. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you use our platform and services.</p>

                <h2>2. Information We Collect</h2>
                <h3>2.1 Personal Information</h3>
                <p>We collect personal information that you provide directly to us, including:</p>
                <ul>
                    <li><strong>Identity Information:</strong> Full name, date of birth, nationality, government-issued ID</li>
                    <li><strong>Contact Information:</strong> Email address, phone number, physical address</li>
                    <li><strong>Financial Information:</strong> Bank account details, transaction history, source of funds</li>
                    <li><strong>Verification Documents:</strong> Passport, driver's license, utility bills, employment verification</li>
                </ul>

                <h3>2.2 Automatically Collected Information</h3>
                <p>We automatically collect certain information when you use our Service:</p>
                <ul>
                    <li><strong>Device Information:</strong> IP address, browser type, operating system, device identifiers</li>
                    <li><strong>Usage Data:</strong> Pages visited, features used, time spent, click patterns</li>
                    <li><strong>Transaction Data:</strong> Transaction amounts, timestamps, counterparties, references</li>
                    <li><strong>Location Data:</strong> General geographic location based on IP address</li>
                </ul>

                <h3>2.3 Information from Third Parties</h3>
                <p>We may receive information about you from:</p>
                <ul>
                    <li>Banking partners and financial service providers</li>
                    <li>Identity verification and KYC service providers</li>
                    <li>Credit bureaus and fraud prevention services</li>
                    <li>Public databases and government registries</li>
                </ul>

                <h2>3. How We Use Your Information</h2>
                <p>We use your information for the following purposes:</p>

                <h3>3.1 Service Provision</h3>
                <ul>
                    <li>Creating and managing your account</li>
                    <li>Processing transactions and transfers</li>
                    <li>Providing customer support</li>
                    <li>Facilitating currency exchanges</li>
                    <li>Managing bank allocations and distributions</li>
                </ul>

                <h3>3.2 Legal and Regulatory Compliance</h3>
                <ul>
                    <li>Verifying your identity (KYC procedures)</li>
                    <li>Monitoring for money laundering and terrorist financing (AML)</li>
                    <li>Reporting to regulatory authorities as required</li>
                    <li>Maintaining transaction records for audit purposes</li>
                </ul>

                <h3>3.3 Security and Fraud Prevention</h3>
                <ul>
                    <li>Detecting and preventing fraudulent activities</li>
                    <li>Monitoring for suspicious transactions</li>
                    <li>Securing our platform and systems</li>
                    <li>Investigating security incidents</li>
                </ul>

                <h3>3.4 Communication and Marketing</h3>
                <ul>
                    <li>Sending transaction confirmations and account updates</li>
                    <li>Providing important service announcements</li>
                    <li>Sending promotional materials (with your consent)</li>
                    <li>Responding to your inquiries and requests</li>
                </ul>

                <h2>4. Information Sharing and Disclosure</h2>
                <h3>4.1 Service Providers</h3>
                <p>We may share your information with trusted third-party service providers who assist us in operating our platform, including:</p>
                <ul>
                    <li>Banking partners for fund custody and transfers</li>
                    <li>Payment processors for transaction handling</li>
                    <li>Identity verification services for KYC compliance</li>
                    <li>Cloud infrastructure providers for data storage</li>
                    <li>Customer support and communication platforms</li>
                </ul>

                <h3>4.2 Legal Requirements</h3>
                <p>We may disclose your information when required by law or in response to:</p>
                <ul>
                    <li>Court orders, subpoenas, or other legal processes</li>
                    <li>Regulatory inquiries or investigations</li>
                    <li>Law enforcement requests</li>
                    <li>Compliance with anti-money laundering regulations</li>
                </ul>

                <h3>4.3 Business Transfers</h3>
                <p>In the event of a merger, acquisition, or sale of assets, your information may be transferred to the new entity, subject to the same privacy protections.</p>

                <h2>5. Data Security</h2>
                <p>We implement robust security measures to protect your information:</p>
                <ul>
                    <li><strong>Encryption:</strong> All data is encrypted in transit and at rest using industry-standard algorithms</li>
                    <li><strong>Access Controls:</strong> Strict access controls limit who can view your information</li>
                    <li><strong>Multi-Factor Authentication:</strong> Required for all sensitive operations</li>
                    <li><strong>Regular Audits:</strong> Security assessments and penetration testing</li>
                    <li><strong>Incident Response:</strong> Procedures for detecting and responding to breaches</li>
                </ul>

                <h2>6. Data Retention</h2>
                <p>We retain your information for as long as necessary to:</p>
                <ul>
                    <li>Provide our services to you</li>
                    <li>Comply with legal and regulatory requirements</li>
                    <li>Resolve disputes and enforce our agreements</li>
                    <li>Maintain business records for audit purposes</li>
                </ul>
                <p>Typically, we retain transaction records for 7 years after account closure, as required by financial regulations.</p>

                <h2>7. Your Rights (GDPR)</h2>
                <p>If you are in the European Economic Area, you have the following rights:</p>
                <ul>
                    <li><strong>Access:</strong> Request copies of your personal data</li>
                    <li><strong>Rectification:</strong> Request correction of inaccurate data</li>
                    <li><strong>Erasure:</strong> Request deletion of your data (subject to legal requirements)</li>
                    <li><strong>Restriction:</strong> Request limitation of processing</li>
                    <li><strong>Portability:</strong> Request transfer of your data</li>
                    <li><strong>Objection:</strong> Object to certain types of processing</li>
                    <li><strong>Withdraw Consent:</strong> Withdraw consent for consent-based processing</li>
                </ul>

                <h2>8. International Transfers</h2>
                <p>Your information may be processed in countries other than your own. We ensure adequate protection through:</p>
                <ul>
                    <li>Standard Contractual Clauses approved by the European Commission</li>
                    <li>Adequacy decisions recognizing equivalent protection levels</li>
                    <li>Certification schemes and codes of conduct</li>
                </ul>

                <h2>9. Cookies and Tracking Technologies</h2>
                <p>We use cookies and similar technologies to:</p>
                <ul>
                    <li>Remember your preferences and settings</li>
                    <li>Authenticate your identity and maintain sessions</li>
                    <li>Analyze usage patterns and improve our service</li>
                    <li>Prevent fraud and enhance security</li>
                </ul>
                <p>You can control cookie settings through your browser preferences.</p>

                <h2>10. Children's Privacy</h2>
                <p>Our Service is not intended for individuals under 18 years of age. We do not knowingly collect personal information from children under 18. If you become aware that a child has provided us with personal information, please contact us.</p>

                <h2>11. Changes to This Privacy Policy</h2>
                <p>We may update this Privacy Policy from time to time. We will notify you of any material changes by:</p>
                <ul>
                    <li>Posting the new Privacy Policy on our website</li>
                    <li>Sending you an email notification</li>
                    <li>Displaying a prominent notice on our platform</li>
                </ul>

                <h2>12. Contact Information</h2>
                <p>For privacy-related questions or to exercise your rights, contact us at:</p>
                <div class="bg-gray-50 p-6 rounded-lg mt-6">
                    <p><strong>Data Protection Officer</strong><br>
                    Email: {{ config('brand.privacy_email') }}<br>
                    Address: {{ config('brand.legal_jurisdiction') }}</p>
                </div>

                <h2>13. Data Processing Legal Bases</h2>
                <p>We process your personal data based on the following legal grounds:</p>
                <ul>
                    <li><strong>Contract Performance:</strong> Processing necessary to provide our services</li>
                    <li><strong>Legal Obligation:</strong> Compliance with KYC, AML, and other regulations</li>
                    <li><strong>Legitimate Interest:</strong> Fraud prevention, security, and service improvement</li>
                    <li><strong>Consent:</strong> Marketing communications and optional features</li>
                </ul>

                <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mt-8">
                    <p class="text-sm text-blue-800">
                        <strong>Questions about Privacy?</strong> We're committed to transparency about our data practices. If you have any questions or concerns about how we handle your personal information, please don't hesitate to contact our Data Protection Officer.
                    </p>
                </div>
            </div>
        </div>
    </div>
</x-guest-layout>