<x-guest-layout>
    <div class="bg-white">
        <!-- Header -->
        <div class="bg-gray-50 border-b">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
                <h1 class="text-4xl font-bold text-gray-900">Cookie Policy</h1>
                <p class="mt-4 text-lg text-gray-600">Last updated: December 23, 2025</p>
            </div>
        </div>

        <!-- Content -->
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="prose prose-lg max-w-none">
                
                <h2>1. What Are Cookies</h2>
                <p>Cookies are small text files that are stored on your device when you visit our website. They help us provide you with a better experience by remembering your preferences and enabling essential functionality.</p>

                <h2>2. How We Use Cookies</h2>
                <p>{{ config('brand.name') }} uses cookies for several purposes:</p>

                <h3>2.1 Essential Cookies</h3>
                <p>These cookies are necessary for the website to function properly:</p>
                <ul>
                    <li><strong>Authentication:</strong> Keep you logged in during your session</li>
                    <li><strong>Security:</strong> Protect against cross-site request forgery (CSRF)</li>
                    <li><strong>Session Management:</strong> Maintain your session state across pages</li>
                    <li><strong>Load Balancing:</strong> Ensure you're directed to the correct server</li>
                </ul>

                <h3>2.2 Functional Cookies</h3>
                <p>These cookies enhance your experience:</p>
                <ul>
                    <li><strong>Language Preferences:</strong> Remember your chosen language</li>
                    <li><strong>Currency Display:</strong> Remember your preferred currency format</li>
                    <li><strong>Theme Preferences:</strong> Remember dark/light mode selection</li>
                    <li><strong>Form Data:</strong> Save partially completed forms</li>
                </ul>

                <h3>2.3 Analytics Cookies</h3>
                <p>These cookies help us understand how you use our website:</p>
                <ul>
                    <li><strong>Usage Statistics:</strong> Track page views and user interactions</li>
                    <li><strong>Performance Monitoring:</strong> Identify slow-loading pages</li>
                    <li><strong>Error Tracking:</strong> Detect and fix technical issues</li>
                    <li><strong>Feature Usage:</strong> Understand which features are most popular</li>
                </ul>

                <h3>2.4 Security Cookies</h3>
                <p>These cookies help protect your account:</p>
                <ul>
                    <li><strong>Fraud Detection:</strong> Identify suspicious login patterns</li>
                    <li><strong>Device Recognition:</strong> Remember trusted devices</li>
                    <li><strong>Rate Limiting:</strong> Prevent automated attacks</li>
                    <li><strong>Multi-Factor Authentication:</strong> Support 2FA functionality</li>
                </ul>

                <h2>3. Types of Cookies We Use</h2>
                
                <div class="bg-gray-50 rounded-lg p-6 my-6">
                    <table class="w-full text-sm">
                        <thead>
                            <tr class="border-b border-gray-200">
                                <th class="text-left py-2 font-semibold">Cookie Name</th>
                                <th class="text-left py-2 font-semibold">Purpose</th>
                                <th class="text-left py-2 font-semibold">Duration</th>
                                <th class="text-left py-2 font-semibold">Type</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <tr>
                                <td class="py-2 font-mono">{{ config('session.cookie', 'laravel_session') }}</td>
                                <td class="py-2">User authentication and session management</td>
                                <td class="py-2">Session</td>
                                <td class="py-2">Essential</td>
                            </tr>
                            <tr>
                                <td class="py-2 font-mono">csrf_token</td>
                                <td class="py-2">Cross-site request forgery protection</td>
                                <td class="py-2">Session</td>
                                <td class="py-2">Essential</td>
                            </tr>
                            <tr>
                                <td class="py-2 font-mono">language_pref</td>
                                <td class="py-2">Remember selected language</td>
                                <td class="py-2">1 year</td>
                                <td class="py-2">Functional</td>
                            </tr>
                            <tr>
                                <td class="py-2 font-mono">currency_pref</td>
                                <td class="py-2">Remember preferred currency display</td>
                                <td class="py-2">1 year</td>
                                <td class="py-2">Functional</td>
                            </tr>
                            <tr>
                                <td class="py-2 font-mono">theme_mode</td>
                                <td class="py-2">Remember dark/light theme preference</td>
                                <td class="py-2">1 year</td>
                                <td class="py-2">Functional</td>
                            </tr>
                            <tr>
                                <td class="py-2 font-mono">analytics_id</td>
                                <td class="py-2">Anonymous usage analytics</td>
                                <td class="py-2">2 years</td>
                                <td class="py-2">Analytics</td>
                            </tr>
                            <tr>
                                <td class="py-2 font-mono">device_trust</td>
                                <td class="py-2">Remember trusted devices for security</td>
                                <td class="py-2">90 days</td>
                                <td class="py-2">Security</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <h2>4. Third-Party Cookies</h2>
                <p>We may use third-party services that set their own cookies:</p>

                <h3>4.1 Security Services</h3>
                <ul>
                    <li><strong>Cloudflare:</strong> DDoS protection and content delivery</li>
                    <li><strong>reCAPTCHA:</strong> Bot detection and spam prevention</li>
                </ul>

                <h3>4.2 Analytics Services</h3>
                <ul>
                    <li><strong>Self-hosted Analytics:</strong> We use our own analytics system to protect your privacy</li>
                    <li><strong>Error Monitoring:</strong> Technical error tracking for service improvement</li>
                </ul>

                <h2>5. Managing Your Cookie Preferences</h2>
                
                <h3>5.1 Browser Settings</h3>
                <p>You can control cookies through your browser settings:</p>
                <ul>
                    <li><strong>Chrome:</strong> Settings > Privacy and Security > Cookies</li>
                    <li><strong>Firefox:</strong> Settings > Privacy & Security > Cookies and Site Data</li>
                    <li><strong>Safari:</strong> Preferences > Privacy > Cookies and website data</li>
                    <li><strong>Edge:</strong> Settings > Site permissions > Cookies and site data</li>
                </ul>

                <h3>5.2 Our Cookie Preferences</h3>
                <p>You can manage your cookie preferences directly on our platform:</p>
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mt-6">
                    <h4 class="font-semibold text-blue-900 mb-3">Cookie Preference Center</h4>
                    <div class="space-y-3">
                        <label class="flex items-center">
                            <input type="checkbox" checked disabled class="mr-3">
                            <span class="text-blue-800">Essential Cookies (Required)</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" checked class="mr-3">
                            <span class="text-blue-800">Functional Cookies</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" checked class="mr-3">
                            <span class="text-blue-800">Analytics Cookies</span>
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" checked class="mr-3">
                            <span class="text-blue-800">Security Cookies</span>
                        </label>
                    </div>
                    <button class="mt-4 bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 transition duration-200">
                        Save Preferences
                    </button>
                </div>

                <h2>6. Impact of Disabling Cookies</h2>
                <p>If you disable certain cookies, some features may not work properly:</p>
                <ul>
                    <li><strong>Essential Cookies:</strong> You won't be able to log in or use secure features</li>
                    <li><strong>Functional Cookies:</strong> Your preferences won't be remembered</li>
                    <li><strong>Analytics Cookies:</strong> We can't improve our service based on usage data</li>
                    <li><strong>Security Cookies:</strong> Enhanced security features may be disabled</li>
                </ul>

                <h2>7. Data Protection</h2>
                <p>We protect cookie data through:</p>
                <ul>
                    <li><strong>Encryption:</strong> All cookies are encrypted in transit and at rest</li>
                    <li><strong>Secure Flags:</strong> Cookies are marked as secure and HTTP-only where appropriate</li>
                    <li><strong>Domain Restrictions:</strong> Cookies are restricted to our domain only</li>
                    <li><strong>Expiration:</strong> All cookies have appropriate expiration dates</li>
                </ul>

                <h2>8. Updates to This Policy</h2>
                <p>We may update this Cookie Policy to reflect changes in our practices or applicable laws. We will notify you of any material changes by:</p>
                <ul>
                    <li>Posting the updated policy on our website</li>
                    <li>Sending you an email notification</li>
                    <li>Displaying a prominent notice on our platform</li>
                </ul>

                <h2>9. Contact Us</h2>
                <p>If you have questions about our use of cookies, please contact us:</p>
                <div class="bg-gray-50 p-6 rounded-lg mt-6">
                    <p><strong>Data Protection Officer</strong><br>
                    Email: {{ config('brand.privacy_email') }}<br>
                    Address: {{ config('brand.legal_jurisdiction') }}</p>
                </div>

                <div class="bg-green-50 border border-green-200 rounded-lg p-6 mt-8">
                    <p class="text-sm text-green-800">
                        <strong>Your Privacy Matters:</strong> We use cookies responsibly to enhance your experience while protecting your privacy. You have full control over your cookie preferences and can change them at any time.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Cookie preference management
        document.addEventListener('DOMContentLoaded', function() {
            // Load saved preferences
            const savedPrefs = localStorage.getItem('cookiePreferences');
            if (savedPrefs) {
                const prefs = JSON.parse(savedPrefs);
                document.querySelectorAll('input[type="checkbox"]:not([disabled])').forEach(checkbox => {
                    const type = checkbox.nextElementSibling.textContent.toLowerCase().replace(' cookies', '');
                    if (prefs[type] !== undefined) {
                        checkbox.checked = prefs[type];
                    }
                });
            }

            // Save preferences
            const saveButton = document.querySelector('button');
            if (saveButton) {
                saveButton.addEventListener('click', function() {
                    const preferences = {};
                    document.querySelectorAll('input[type="checkbox"]:not([disabled])').forEach(checkbox => {
                        const type = checkbox.nextElementSibling.textContent.toLowerCase().replace(' cookies', '');
                        preferences[type] = checkbox.checked;
                    });
                    
                    localStorage.setItem('cookiePreferences', JSON.stringify(preferences));
                    
                    // Show success message
                    const successMsg = document.createElement('div');
                    successMsg.className = 'mt-2 text-green-600 text-sm';
                    successMsg.textContent = 'Preferences saved successfully!';
                    saveButton.parentNode.appendChild(successMsg);
                    
                    setTimeout(() => successMsg.remove(), 3000);
                });
            }
        });
    </script>
</x-guest-layout>