# v1.4.0 Implementation Plan - Quality & Coverage

> **Target**: Q1 2026
> **Theme**: Test Coverage & Security Hardening
> **Created**: January 25, 2026
> **Last Updated**: January 25, 2026

---

## Implementation Status

| Phase | Description | Status |
|-------|-------------|--------|
| Phase 1.1 | PHPStan Level 8 Compliance | ✅ **COMPLETE** |
| Phase 1.2 | Security Authentication Fixes | ✅ **COMPLETE** |
| Phase 2.1 | Fraud Domain Tests (18) | ✅ **COMPLETE** |
| Phase 2.2 | Regulatory Domain Tests (13) | ✅ **COMPLETE** |
| Phase 2.3 | Stablecoin Domain Tests (24) | ✅ **COMPLETE** |
| Phase 2.4 | Wallet Domain Tests (37) | ✅ **COMPLETE** |
| Phase 3.1 | Domain Create Command | ✅ **COMPLETE** |
| Phase 3.2 | Domain Test Scaffold Command | 🔲 Pending |
| Phase 4.1 | AI Domain Tests (55) | ✅ **COMPLETE** |
| Phase 4.2 | Batch Domain Tests (37) | ✅ **COMPLETE** |
| Phase 4.3 | CGO Domain Tests | 🔲 Pending |
| Phase 4.4 | FinancialInstitution Domain Tests | 🔲 Pending |

**Total Tests Added**: 184 (AI: 55, Batch: 37, Fraud: 18, Wallet: 37, Regulatory: 13, Stablecoin: 24)

---

## Executive Summary

Following the v1.3.0 Platform Modularity release, v1.4.0 focuses on **quality assurance** and **security hardening**. This release addresses:
- Test coverage gaps in 16 domains
- Security authentication vulnerabilities
- PHPStan Level 8 compliance
- Domain scaffolding tooling

---

## Current State Analysis

### Test Coverage Gaps

| Priority | Domain | Has Services | Has Models | Has Events | Status |
|----------|--------|-------------|------------|------------|--------|
| **Critical** | Fraud | Yes | Yes | Yes | ✅ **18 Tests** |
| **Critical** | Regulatory | Yes | Yes | Yes | ✅ **13 Tests** |
| **Critical** | Stablecoin | Yes | Yes | Yes | ✅ **24 Tests** |
| **Critical** | Wallet | Yes | Yes | Yes | ✅ **37 Tests** |
| High | AI | Yes | No | Yes | ✅ **55 Tests** |
| High | Batch | Yes | Yes | Yes | ✅ **37 Tests** |
| High | Cgo | Yes | Yes | Yes | No Tests |
| High | FinancialInstitution | Yes | Yes | Yes | No Tests |
| Medium | Monitoring | Yes | No | Yes | No Tests |
| Medium | Performance | Yes | Yes | Yes | No Tests |
| Medium | Product | Yes | Yes | Yes | No Tests |
| Medium | Webhook | Yes | Yes | No | No Tests |
| Low | Activity | No | Yes | No | No Tests |
| Low | Contact | No | Yes | No | No Tests |
| Low | Newsletter | Yes | Yes | No | No Tests |
| Low | Shared | No | No | Yes | No Tests |

### Security Issues

**Status**: ✅ **RESOLVED**

| Issue | Location | Severity | Status |
|-------|----------|----------|--------|
| ~~Rate limiting allows 5 attempts instead of 3~~ | config/rate_limiting.php | High | ✅ Fixed |
| ~~Token expiration not enforced~~ | Auth controllers | Critical | ✅ Fixed |
| ~~Token invalidation not immediate~~ | Logout handlers | Critical | ✅ Already correct |
| ~~Scope-based authorization incomplete~~ | CheckApiScope middleware | High | ✅ Fixed |
| ~~Empty scopes bypass in AgentScope~~ | AgentScope enum | Critical | ✅ Fixed |
| ~~Session limit allows 5 instead of 3~~ | config/auth.php | Medium | ✅ Fixed |

### PHPStan Errors

**Status**: ✅ **RESOLVED**

~~**File**: `app/Domain/Account/Services/AccountQueryService.php`~~

All 10 PHPStan Level 8 errors have been fixed:
- Added PHPDoc annotations for model properties
- Fixed type annotations for where clause parameters
- Added Collection return type annotations
- Fixed toIso8601String call type safety
- Corrected array shape return types

---

## Implementation Phases

### Phase 1: Critical Fixes (Week 1)

#### 1.1 PHPStan Level 8 Compliance ✅ COMPLETE
- ~~Fix 10 errors in AccountQueryService~~ ✅
- ~~Add missing type annotations~~ ✅
- ~~Update PHPStan baseline if needed~~ ✅

#### 1.2 Security Authentication Fixes 🔲 PENDING
- Fix rate limiting threshold (3 attempts)
- Enforce token expiration
- Implement immediate token invalidation
- Add scope-based authorization

### Phase 2: Critical Domain Tests (Week 2)

#### 2.1 Fraud Domain Tests ✅ COMPLETE (18 tests)
```
tests/Domain/Fraud/
└── Services/
    └── FraudDetectionServiceTest.php  ✅ 18 tests
        - Pattern detection (high-value, velocity, geographic, time-based, round amounts)
        - Risk scoring and multiplier calculations
        - Pattern aggregation logic
```

#### 2.2 Regulatory Domain Tests ✅ COMPLETE (13 tests)
```
tests/Domain/Regulatory/
└── Services/
    └── ReportGeneratorServiceTest.php  ✅ 13 tests
        - CSV header extraction (CTR, SAR, KYC, default)
        - Certification statements by report type
        - Filename generation with dates/extensions
        - XML conversion (simple, nested, indexed arrays)
```

#### 2.3 Stablecoin Domain Tests ✅ COMPLETE (24 tests)
```
tests/Domain/Stablecoin/
└── ValueObjects/
    └── StablecoinValueObjectsTest.php  ✅ 24 tests
        - LiquidationThreshold (levels, margin calls, liquidation)
        - CollateralRatio (percentage, health, BigDecimal)
        - PriceData (properties, staleness, metadata)
```

#### 2.4 Wallet Domain Tests ✅ COMPLETE (37 tests)
```
tests/Domain/Wallet/
├── Services/
│   └── KeyManagementServiceTest.php  ✅ 23 tests
│       - BIP39 mnemonic generation/validation
│       - BIP32/BIP44 key derivation
│       - Multi-chain address generation
│       - Signature operations
└── ValueObjects/
    └── WalletValueObjectsTest.php  ✅ 14 tests
        - WalletAddress (properties, toArray)
        - TransactionResult (status helpers, serialization)
```

### Phase 3: Domain Scaffolding (Week 3)

#### 3.1 Domain Create Command ✅ COMPLETE
```bash
php artisan domain:create {name}
    --type=optional
    --with-events
    --with-workflows
    --with-tests
```

**Implemented**: `app/Infrastructure/Domain/Commands/DomainCreateCommand.php`

Generates:
```
app/Domain/{Name}/
├── module.json
├── Services/
├── Models/
├── Events/
├── Repositories/
└── {Name}ServiceProvider.php
```

#### 3.2 Domain Test Scaffold Command 🔲 PENDING
```bash
php artisan domain:scaffold-tests {domain}
```

Generates test stubs for:
- All services (unit tests)
- All models (feature tests)
- All events (integration tests)

#### 3.3 Test Utilities ✅ ADDED
```
tests/Traits/
└── InvokesPrivateMethods.php  ✅ NEW
    - invokeMethod() - Invoke private/protected methods
    - getPrivateProperty() - Read private property values
    - setPrivateProperty() - Set private property values
```

### Phase 4: High Priority Domain Tests (Week 4)

#### 4.1 AI Domain Tests
- MCPServerService tests
- ConversationService tests
- Tool execution tests

#### 4.2 Batch Domain Tests
- BatchProcessor tests
- Job scheduling tests
- Retry logic tests

#### 4.3 CGO Domain Tests
- Offering lifecycle tests
- Investment flow tests
- Distribution tests

#### 4.4 FinancialInstitution Domain Tests
- Institution management tests
- Integration tests
- Webhook tests

---

## Success Metrics

| Metric | Start | Current | Target v1.4.0 |
|--------|-------|---------|---------------|
| Test coverage | ~50% | ~58% | 65% |
| Domains with tests | 13/29 | **19/29** | 21/29 |
| PHPStan errors | 10 | **0** ✅ | 0 |
| Security TODOs | 6 | **0** ✅ | 0 |
| Critical domains tested | 0/4 | **4/4** ✅ | 4/4 |
| High priority domains tested | 0/4 | **2/4** | 4/4 |
| New tests added | 0 | **184** ✅ | 150+ |

---

## Risk Mitigation

| Risk | Probability | Impact | Mitigation |
|------|-------------|--------|------------|
| Test isolation issues | Medium | High | Use CleansUpSecurityState trait |
| Redis dependency in tests | High | High | Configure array cache for tests |
| Breaking changes | Low | Medium | Run full test suite before merge |
| Time constraints | Medium | Medium | Prioritize critical domains first |

---

## Files to Create

```
docs/V1.4.0_IMPLEMENTATION_PLAN.md           # This file

app/Infrastructure/Domain/Commands/
├── DomainCreateCommand.php                   # NEW
└── DomainScaffoldTestsCommand.php            # NEW

tests/Domain/Fraud/
├── Services/FraudDetectionServiceTest.php    # NEW
└── ...

tests/Domain/Regulatory/
├── Services/RegulatoryReportingServiceTest.php # NEW
└── ...

tests/Domain/Stablecoin/
├── Services/MintingServiceTest.php           # NEW
└── ...

tests/Domain/Wallet/
├── Services/WalletServiceTest.php            # NEW
└── ...
```

---

## Dependencies

- **v1.3.0**: Module manifest system (completed)
- **Upstream**: laravel-workflow package (LiquidityRetryPolicy blocked)
- **Infrastructure**: Redis or array cache configuration for tests

---

## Next Steps

1. ~~**Immediate**: Fix PHPStan errors in AccountQueryService~~ ✅ DONE
2. ~~**This Week**: Create domain:create scaffolding command~~ ✅ DONE
3. ~~**Week 2**: Add tests for Fraud, Regulatory, Stablecoin, Wallet~~ ✅ DONE (92 tests)
4. ~~**Next**: Add tests for AI, Batch domains~~ ✅ DONE (92 more tests)
5. **Next**: Security authentication hardening
6. **Future**: Add tests for CGO, FinancialInstitution domains
7. **Future**: Domain test scaffold command

---

*Document Version: 1.1*
*Created: January 25, 2026*
*Updated: January 25, 2026*
