# FinAegis P2P Lending User Guide

**Last Updated:** 2024-09-07  
**Version:** 1.0

## Overview

FinAegis P2P Lending connects borrowers seeking loans with lenders looking for investment opportunities. Our platform facilitates secure, transparent lending with competitive rates and comprehensive risk management.

## Table of Contents

1. [Getting Started](#getting-started)
2. [For Borrowers](#for-borrowers)
3. [For Lenders](#for-lenders)
4. [Loan Management](#loan-management)
5. [Risk and Returns](#risk-and-returns)
6. [Security and Compliance](#security-and-compliance)
7. [FAQs](#faqs)

## Getting Started

### Prerequisites

**For Borrowers:**
- Enhanced KYC verification (for loans >$1,000)
- Credit score calculation
- Sufficient collateral (if required)
- Verified income source

**For Lenders:**
- Basic KYC verification
- Minimum investment: $100
- Risk acknowledgment
- Available funds in account

### Platform Overview

- **Loan Terms**: 3-60 months
- **Interest Rates**: 5-25% APR
- **Loan Amounts**: $100 - $100,000
- **Collateral Options**: Crypto, account balance, external assets

## For Borrowers

### Applying for a Loan

#### Step 1: Check Eligibility

1. Navigate to **Lending → Borrow**
2. Click **Check Eligibility**
3. View your:
   - Credit score (300-850)
   - Maximum loan amount
   - Minimum interest rate
   - Available collateral

#### Step 2: Create Application

1. Click **Apply for Loan**
2. Enter loan details:
   - Amount needed
   - Loan purpose
   - Preferred term
   - Repayment source

3. Select collateral (if required):
   - Crypto holdings
   - Account balance
   - External assets

4. Review terms:
   - Interest rate range
   - Monthly payment estimate
   - Total cost

#### Step 3: Submit Application

1. Review all information
2. Accept terms and conditions
3. Submit application
4. Wait for lender funding

### Loan Purposes

Common approved purposes:
- **Business Expansion**: Working capital, inventory
- **Debt Consolidation**: Lower interest rates
- **Personal Use**: Education, medical, home improvement
- **Investment**: Trading capital (with restrictions)

### Interest Rates

Rates determined by:
- Credit score (40%)
- Loan amount (20%)
- Term length (15%)
- Collateral (15%)
- Market conditions (10%)

### Example Loan Calculation

```
Loan Amount: $10,000
Term: 12 months
Interest Rate: 10.5% APR
Monthly Payment: $877.84
Total Interest: $534.08
Total Repayment: $10,534.08
```

### Managing Your Loan

#### Making Payments

1. **Automatic Payments**
   - Set up auto-debit
   - Choose payment date
   - Ensure sufficient balance

2. **Manual Payments**
   - Go to **My Loans**
   - Click **Make Payment**
   - Enter amount
   - Confirm transaction

3. **Early Repayment**
   - Calculate payoff amount
   - Check for penalties (usually 1%)
   - Save on interest

#### Payment Schedule

View your amortization schedule:
- Principal vs interest breakdown
- Remaining balance
- Payment due dates
- Late payment penalties

### Default Prevention

**Warning Signs:**
- Upcoming payment without funds
- Changed financial situation
- Multiple missed payments

**Actions to Take:**
1. Contact support immediately
2. Request payment plan modification
3. Consider refinancing
4. Add additional collateral

## For Lenders

### Investment Strategy

#### Risk Categories

**Grade A (Low Risk)**
- Credit Score: 750+
- Collateral: 150%+
- Default Rate: <1%
- Returns: 5-8% APR

**Grade B (Medium Risk)**
- Credit Score: 650-749
- Collateral: 120%+
- Default Rate: 1-3%
- Returns: 8-12% APR

**Grade C (Higher Risk)**
- Credit Score: 550-649
- Collateral: 100%+
- Default Rate: 3-5%
- Returns: 12-20% APR

### Finding Loans to Fund

#### Browse Marketplace

1. Go to **Lending → Invest**
2. Filter by:
   - Risk grade
   - Interest rate
   - Term length
   - Loan purpose
   - Collateral type

3. Review borrower profiles:
   - Credit score
   - Loan history
   - Income verification
   - Collateral details

#### Due Diligence

Before investing, check:
- **Borrower History**: Previous loans, repayment record
- **Collateral Value**: Current market value, volatility
- **Purpose Validity**: Reasonable use of funds
- **Risk/Return**: Appropriate for your portfolio

### Funding Process

1. **Select Loan**
   - Click on loan listing
   - Review full details
   - Check funding progress

2. **Choose Investment Amount**
   - Minimum: $100
   - Maximum: Full loan amount
   - Consider diversification

3. **Confirm Investment**
   - Review terms
   - Accept lender agreement
   - Transfer funds

4. **Monitor Investment**
   - Track payments
   - View returns
   - Manage portfolio

### Portfolio Management

#### Diversification Strategy

**Recommended Allocation:**
- 50% Grade A loans
- 35% Grade B loans
- 15% Grade C loans

**By Term:**
- 40% Short-term (3-12 months)
- 40% Medium-term (13-36 months)
- 20% Long-term (37-60 months)

#### Performance Tracking

Monitor key metrics:
- **Total Invested**: Sum of all active loans
- **Current Returns**: Weighted average APR
- **Default Rate**: Percentage of defaulted loans
- **Net Returns**: After fees and losses

### Automated Investing

Set up auto-invest criteria:
1. Risk preferences
2. Rate requirements
3. Term preferences
4. Maximum per loan
5. Total investment limit

## Loan Management

### For Active Loans

#### Payment Processing

- **Collection**: Automatic on due date
- **Distribution**: Within 24 hours
- **Notifications**: Email/SMS alerts
- **Statements**: Monthly summaries

#### Communication

- Secure messaging with counterparty
- Support ticket system
- Dispute resolution process

### Loan Modifications

#### Refinancing Options

**For Borrowers:**
- Lower interest rates
- Extended terms
- Reduced payments

**Process:**
1. Check eligibility
2. Submit refinance request
3. Get lender approval
4. Sign new agreement

#### Payment Plans

If struggling with payments:
1. Request modification
2. Provide documentation
3. Negotiate new terms
4. Maintain communication

## Risk and Returns

### Understanding Risks

#### For Lenders

1. **Default Risk**
   - Borrower inability to repay
   - Mitigated by collateral
   - Diversification helps

2. **Liquidity Risk**
   - Funds locked until maturity
   - No secondary market (yet)
   - Plan accordingly

3. **Collateral Risk**
   - Value fluctuations
   - Liquidation delays
   - Market conditions

#### For Borrowers

1. **Collateral Loss**
   - Liquidation on default
   - Market value changes
   - Margin calls

2. **Credit Impact**
   - Reported to credit agencies
   - Affects future borrowing
   - Long-term consequences

### Expected Returns

#### Historical Performance

**By Grade (Annual):**
- Grade A: 6.5% average (5-8% range)
- Grade B: 9.8% average (8-12% range)
- Grade C: 15.2% average (12-20% range)

**After Defaults:**
- Grade A: 6.4% net
- Grade B: 9.2% net
- Grade C: 13.8% net

### Risk Mitigation

#### For Lenders

1. **Diversify Portfolio**
   - Multiple small loans
   - Various risk grades
   - Different terms

2. **Focus on Collateralized Loans**
   - Crypto collateral
   - Over-collateralization
   - Automatic liquidation

3. **Research Thoroughly**
   - Verify information
   - Check histories
   - Understand purposes

#### For Borrowers

1. **Borrow Responsibly**
   - Within means
   - Clear repayment plan
   - Emergency buffer

2. **Maintain Collateral**
   - Monitor values
   - Add if needed
   - Avoid liquidation

## Security and Compliance

### Platform Security

- **Encryption**: All data encrypted
- **Smart Contracts**: Audited code
- **Fund Segregation**: Separate accounts
- **Insurance**: Platform insurance coverage

### Regulatory Compliance

- **KYC/AML**: Full compliance
- **Reporting**: Tax documents provided
- **Licensing**: Regulated platform
- **Fair Lending**: Equal opportunity

### Dispute Resolution

1. **Direct Communication**: Try resolving with counterparty
2. **Mediation**: Platform assistance
3. **Arbitration**: Binding resolution
4. **Legal Action**: Last resort

## FAQs

### General Questions

**Q: How are interest rates determined?**
A: Rates are based on credit score, loan amount, term, collateral, and market conditions. Our algorithm provides fair, competitive rates.

**Q: Is there a secondary market?**
A: Not currently, but it's planned for Q4 2024. Loans must be held to maturity for now.

**Q: What happens in case of default?**
A: Collateral is liquidated first. Any shortfall may be pursued through collections. Lenders may experience losses.

### For Borrowers

**Q: Can I pay off my loan early?**
A: Yes, with a small prepayment penalty (typically 1% of remaining balance).

**Q: What credit score do I need?**
A: Minimum 500, but better rates available above 650.

**Q: How quickly can I get funds?**
A: Once fully funded, funds are available within 24 hours.

### For Lenders

**Q: What's the minimum investment?**
A: $100 per loan, no maximum (subject to borrower's needs).

**Q: How do I get paid?**
A: Monthly payments are automatically distributed to your account within 24 hours of collection.

**Q: Can I sell my loans?**
A: Not currently, but secondary market coming soon.

## Best Practices

### For Borrowers

1. **Only borrow what you need**
2. **Have a clear repayment plan**
3. **Maintain communication**
4. **Build credit history**
5. **Keep collateral topped up**

### For Lenders

1. **Start small and learn**
2. **Diversify always**
3. **Research thoroughly**
4. **Reinvest returns**
5. **Monitor actively**

## Support Resources

- **Help Center**: help.finaegis.com/lending
- **Video Tutorials**: youtube.com/finaegis
- **Community Forum**: forum.finaegis.com
- **Email Support**: lending@finaegis.com
- **Phone**: 1-800-FINAEGIS

---

**Disclaimer**: P2P lending involves risk of loss. Past performance doesn't guarantee future results. Not FDIC insured. Please invest within your risk tolerance.