# CGO (Continuous Growth Offering) User Guide

**Last Updated:** 2024-09-08  
**Platform Version:** 8.0

## Overview

The Continuous Growth Offering (CGO) is FinAegis's innovative investment platform that allows you to participate in the growth of our financial ecosystem. Unlike traditional investment rounds, CGO provides continuous opportunities to invest and benefit from the platform's success.

## Getting Started

### Accessing CGO

1. **Login** to your FinAegis account at [finaegis.org](https://finaegis.org)
2. Navigate to **Investment** → **CGO** in the main menu
3. Or directly visit [finaegis.org/cgo](https://finaegis.org/cgo)

### Eligibility Requirements

Before investing, you must complete:

| Investment Amount | KYC Level Required | Documents Needed |
|------------------|-------------------|------------------|
| Up to €1,000 | Basic KYC | Government ID, Email verification |
| €1,000 - €10,000 | Enhanced KYC | Proof of address, Source of funds |
| €10,000+ | Full KYC | Financial statements, AML screening |

## Investment Process

### Step 1: KYC Verification

#### First-Time Investors
1. Click **"Start KYC Process"** on the CGO page
2. Upload required documents:
   - Government-issued ID (passport, driver's license, or national ID)
   - Proof of address (utility bill, bank statement within 3 months)
   - Source of funds declaration (for amounts over €1,000)
3. Complete identity verification:
   - Take a selfie for facial recognition
   - Answer security questions
4. Wait for approval (typically 1-2 business days)

#### KYC Status Indicators
- 🟢 **Verified**: Ready to invest
- 🟡 **Pending**: Under review
- 🔴 **Action Required**: Additional documents needed
- ⚫ **Not Started**: Begin KYC process

### Step 2: Review Investment Terms

#### Current Round Information
- **Round**: View current pricing round number
- **Token Price**: Current price per FIN token
- **Available Tokens**: Remaining allocation
- **Round End Date**: When current pricing changes
- **Next Price**: Upcoming price after round closes

#### Token Benefits
- **Governance Rights**: Vote on platform decisions
- **Revenue Sharing**: Quarterly distributions from platform fees
- **Staking Rewards**: Earn additional tokens by staking
- **Premium Features**: Access to advanced platform features
- **Early Access**: Priority access to new products

### Step 3: Calculate Investment

Use the investment calculator:
1. Enter investment amount in EUR/USD
2. View token allocation at current price
3. See projected returns based on growth scenarios
4. Review fee structure:
   - Platform fee: 2%
   - Payment processing: 0.5-2.5% (varies by method)

### Step 4: Choose Payment Method

#### Credit/Debit Card
- **Instant processing**
- **Minimum**: €10
- **Maximum**: €10,000 per transaction
- **Supported cards**: Visa, Mastercard, American Express
- **Processing fee**: 2.5%

#### Bank Transfer (SEPA/Wire)
- **Processing time**: 1-3 business days
- **Minimum**: €100
- **Maximum**: €100,000 per transaction
- **Processing fee**: 0.5%
- **Instructions provided**: IBAN, BIC, Reference number

#### Cryptocurrency
- **Supported coins**: BTC, ETH, USDT, USDC
- **Processing time**: 1-6 confirmations
- **Minimum**: €50 equivalent
- **Maximum**: No limit
- **Processing fee**: 1%
- **Automatic conversion**: At current market rates

### Step 5: Complete Investment

1. Review investment summary:
   - Investment amount
   - Token allocation
   - Total fees
   - Vesting schedule
2. Accept terms and conditions
3. Confirm investment
4. Process payment
5. Receive confirmation email

## Investment Management

### Dashboard Overview

Access your CGO dashboard to view:
- **Portfolio Value**: Current value of your tokens
- **Investment History**: All past investments
- **Token Balance**: Total FIN tokens owned
- **Vesting Schedule**: Locked and available tokens
- **Returns**: Realized and unrealized gains

### Vesting Schedule

Tokens follow a vesting schedule:
- **25%** available immediately
- **25%** after 6 months
- **25%** after 12 months
- **25%** after 18 months

### Staking Options

Maximize returns by staking tokens:

| Staking Period | APY | Early Withdrawal |
|----------------|-----|------------------|
| 30 days | 5% | Allowed (2% penalty) |
| 90 days | 8% | Allowed (5% penalty) |
| 180 days | 12% | Allowed (10% penalty) |
| 365 days | 18% | Not allowed |

### Secondary Market

After vesting, trade tokens on:
- **Internal Exchange**: Trade with other FinAegis users
- **Partner DEXs**: Decentralized exchanges (coming soon)
- **OTC Desk**: For large transactions (>€100,000)

## Refund Policy

### Eligible for Refund
- **KYC rejection**: Full refund within 5 business days
- **Payment failure**: Automatic refund minus processing fees
- **Cooling-off period**: 14 days for EU residents

### Refund Process
1. Navigate to CGO → Investment History
2. Select transaction → Request Refund
3. Choose refund reason
4. Provide bank details (if different from original)
5. Submit request
6. Receive confirmation (5-10 business days)

### Non-Refundable Scenarios
- After 14-day cooling-off period
- Tokens already vested or staked
- Violation of terms of service
- Fraudulent activity detected

## Tax Considerations

### Tax Documentation
- **Investment Certificate**: Proof of investment for tax records
- **Annual Statement**: Year-end summary of holdings
- **Transaction History**: Detailed CSV export available
- **Tax Forms**: Country-specific forms (where applicable)

### Tax Treatment by Region
- **EU**: Generally treated as security tokens
- **US**: May be subject to capital gains tax
- **UK**: Potential CGT implications
- **Other**: Consult local tax advisor

**Note**: FinAegis does not provide tax advice. Please consult with a qualified tax professional.

## Compliance & Security

### AML/KYC Measures
- **Identity Verification**: Government ID + biometric check
- **Source of Funds**: Declaration for large investments
- **PEP Screening**: Politically exposed persons checks
- **Sanctions Screening**: Global sanctions list verification
- **Transaction Monitoring**: Ongoing suspicious activity detection

### Security Features
- **Two-Factor Authentication**: Required for investments >€1,000
- **Email Confirmations**: All investment activities
- **Withdrawal Whitelist**: Pre-approved addresses only
- **Session Security**: Automatic logout after inactivity
- **Audit Trail**: Complete transaction history

## Investment Strategies

### Dollar-Cost Averaging (DCA)
Set up recurring investments:
1. Go to CGO → Recurring Investment
2. Set amount and frequency (weekly/monthly)
3. Choose payment method
4. Enable auto-invest

### Milestone-Based Investing
Invest when platform reaches goals:
- User milestones (100k, 1M users)
- Revenue targets
- Product launches
- Partnership announcements

### Referral Bonuses
Earn additional tokens:
- **5% bonus** for referring new investors
- **2% of referee's investment** as reward
- **Tier bonuses** for multiple referrals
- Track earnings in Referral Dashboard

## FAQs

### General Questions

**Q: What is the minimum investment?**
A: €10 for card payments, €100 for bank transfers, €50 for crypto

**Q: Can I invest from any country?**
A: Currently available in EU, UK, and select other countries. Check eligibility in your account.

**Q: Are tokens tradeable immediately?**
A: 25% are tradeable immediately, rest follow vesting schedule

**Q: What happens if I fail KYC?**
A: Full refund processed within 5 business days

### Technical Questions

**Q: How are token prices determined?**
A: Pricing rounds with progressive increases based on milestones

**Q: What blockchain are tokens on?**
A: Initially on Ethereum, with bridges to Polygon and BSC

**Q: Can I transfer tokens to external wallet?**
A: Yes, after vesting period and KYC verification

**Q: Is there a token supply limit?**
A: Yes, maximum supply of 1 billion FIN tokens

## Support

### Getting Help
- **Live Chat**: Available 24/7 in-app
- **Email**: cgo-support@finaegis.com
- **Phone**: +44 20 1234 5678 (9 AM - 6 PM GMT)
- **Help Center**: [help.finaegis.com/cgo](https://help.finaegis.com/cgo)

### Common Issues

#### Payment Declined
- Check card limits with your bank
- Ensure billing address matches
- Try alternative payment method
- Contact support for manual processing

#### KYC Delays
- Ensure documents are clear and readable
- Check document expiry dates
- Verify address proof is recent (within 3 months)
- Contact support if pending >3 days

#### Token Not Received
- Check vesting schedule
- Verify payment completed successfully
- Allow 1 hour for blockchain confirmations
- Check spam folder for confirmation email

## Legal & Disclaimers

### Important Notices
- CGO tokens are not available to US persons
- Investment involves risk of loss
- Past performance doesn't guarantee future results
- Not FDIC insured or bank guaranteed
- Please read full terms at [finaegis.org/cgo/terms](https://finaegis.org/cgo/terms)

### Regulatory Information
- Regulated by: [Relevant Financial Authority]
- Registration Number: [XXX-XXXXX]
- Prospectus available at: [finaegis.org/cgo/prospectus](https://finaegis.org/cgo/prospectus)

---

**Last reviewed**: September 2024  
**Next review**: September 2024

For the most up-to-date information, always refer to the official CGO page within your FinAegis account.