<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    public function up(): void
    {
        // Drop the old table if it exists
        Schema::dropIfExists('compliance_events');

        // Create new table with Spatie Event Sourcing structure
        Schema::create('compliance_events', function (Blueprint $table) {
            $table->id();
            $table->uuid('aggregate_uuid')->nullable();
            $table->integer('aggregate_version')->unsigned()->nullable();
            $table->integer('event_version')->default(1);
            $table->string('event_class');
            $table->json('event_properties');
            $table->json('meta_data');
            $table->dateTime('created_at');

            $table->index('aggregate_uuid');
            $table->index('event_class');
            $table->index('created_at');
            $table->unique(['aggregate_uuid', 'aggregate_version']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('compliance_events');
    }
};
