<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_health_checks', function (Blueprint $table) {
            $table->id();
            $table->string('service');
            $table->string('check_type');
            $table->enum('status', ['operational', 'degraded', 'down']);
            $table->decimal('response_time', 8, 2)->nullable();
            $table->json('metadata')->nullable();
            $table->text('error_message')->nullable();
            $table->dateTime('checked_at');
            $table->timestamps();

            $table->index(['service', 'checked_at']);
            $table->index(['status', 'checked_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_health_checks');
    }
};
