<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTenantsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('tenants', function (Blueprint $table) {
            $table->string('id')->primary();

            // Custom columns for FinAegis
            // Note: No foreign key constraint here because teams table is created later
            // The relationship is enforced at the application level via Eloquent
            $table->unsignedBigInteger('team_id')->nullable();
            $table->string('name');
            $table->string('plan')->default('default');
            $table->dateTime('trial_ends_at')->nullable();

            $table->timestamps();
            $table->json('data')->nullable();

            // Index for team lookup
            $table->index('team_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('tenants');
    }
}
