<?php

namespace App\Http\Controllers\Api\Documentation;

use OpenApi\Attributes as OA;

#[OA\Schema(
    schema: 'Custodian',
    required: ['id', 'code', 'name', 'type', 'is_active', 'capabilities'],
    properties: [
        new OA\Property(property: 'id', type: 'string', format: 'uuid', example: '123e4567-e89b-12d3-a456-426614174000'),
        new OA\Property(property: 'code', type: 'string', description: 'Unique custodian code', example: 'paysera'),
        new OA\Property(property: 'name', type: 'string', description: 'Custodian display name', example: 'Paysera'),
        new OA\Property(property: 'type', type: 'string', enum: ['bank', 'emi', 'crypto_exchange', 'wallet_provider'], example: 'emi'),
        new OA\Property(property: 'country', type: 'string', description: 'ISO country code', example: 'LT'),
        new OA\Property(property: 'is_active', type: 'boolean', example: true),
        new OA\Property(property: 'capabilities', type: 'array', items: new OA\Items(type: 'string'), example: ['sepa', 'sepa_instant', 'swift']),
        new OA\Property(property: 'supported_currencies', type: 'array', items: new OA\Items(type: 'string'), example: ['EUR', 'USD', 'GBP']),
        new OA\Property(property: 'api_version', type: 'string', example: 'v2.0'),
        new OA\Property(property: 'health_status', type: 'string', enum: ['healthy', 'degraded', 'unhealthy'], example: 'healthy'),
        new OA\Property(property: 'metadata', type: 'object', description: 'Additional custodian-specific data'),
        new OA\Property(property: 'created_at', type: 'string', format: 'date-time'),
        new OA\Property(property: 'updated_at', type: 'string', format: 'date-time'),
    ],
)]
#[OA\Schema(
    schema: 'CustodianBalance',
    required: ['custodian_code', 'currency', 'available_balance', 'pending_balance', 'reserved_balance', 'last_updated'],
    properties: [
        new OA\Property(property: 'custodian_code', type: 'string', example: 'deutsche_bank'),
        new OA\Property(property: 'currency', type: 'string', example: 'EUR'),
        new OA\Property(property: 'available_balance', type: 'integer', description: 'Available balance in cents', example: 10000000),
        new OA\Property(property: 'pending_balance', type: 'integer', description: 'Pending incoming balance in cents', example: 500000),
        new OA\Property(property: 'reserved_balance', type: 'integer', description: 'Reserved for outgoing transfers in cents', example: 200000),
        new OA\Property(property: 'total_balance', type: 'integer', description: 'Total balance including pending', example: 10700000),
        new OA\Property(property: 'last_updated', type: 'string', format: 'date-time'),
        new OA\Property(
            property: 'account_numbers',
            type: 'array',
            items: new OA\Items(
                properties: [
                    new OA\Property(property: 'type', type: 'string', example: 'iban'),
                    new OA\Property(property: 'value', type: 'string', example: 'LT123456789012345678'),
                ],
            ),
        ),
    ],
)]
#[OA\Schema(
    schema: 'CustodianTransfer',
    required: ['id', 'custodian_code', 'direction', 'amount', 'currency', 'status', 'created_at'],
    properties: [
        new OA\Property(property: 'id', type: 'string', format: 'uuid'),
        new OA\Property(property: 'custodian_code', type: 'string', example: 'santander'),
        new OA\Property(property: 'direction', type: 'string', enum: ['incoming', 'outgoing', 'internal'], example: 'outgoing'),
        new OA\Property(property: 'amount', type: 'integer', description: 'Amount in cents', example: 100000),
        new OA\Property(property: 'currency', type: 'string', example: 'EUR'),
        new OA\Property(property: 'status', type: 'string', enum: ['pending', 'processing', 'completed', 'failed', 'cancelled'], example: 'completed'),
        new OA\Property(property: 'reference', type: 'string', description: 'Internal reference', example: 'TRF-2025-001'),
        new OA\Property(property: 'external_reference', type: 'string', description: 'Custodian\'s reference', example: 'SEPA123456'),
        new OA\Property(
            property: 'from_account',
            type: 'object',
            properties: [
                new OA\Property(property: 'iban', type: 'string', example: 'LT123456789012345678'),
                new OA\Property(property: 'name', type: 'string', example: 'John Doe'),
            ],
        ),
        new OA\Property(
            property: 'to_account',
            type: 'object',
            properties: [
                new OA\Property(property: 'iban', type: 'string', example: 'DE89370400440532013000'),
                new OA\Property(property: 'name', type: 'string', example: 'Jane Smith'),
            ],
        ),
        new OA\Property(
            property: 'fees',
            type: 'object',
            properties: [
                new OA\Property(property: 'amount', type: 'integer', example: 250),
                new OA\Property(property: 'currency', type: 'string', example: 'EUR'),
            ],
        ),
        new OA\Property(property: 'executed_at', type: 'string', format: 'date-time'),
        new OA\Property(property: 'created_at', type: 'string', format: 'date-time'),
    ],
)]
#[OA\Schema(
    schema: 'InitiateCustodianTransferRequest',
    required: ['from_custodian', 'to_custodian', 'amount', 'currency'],
    properties: [
        new OA\Property(property: 'from_custodian', type: 'string', description: 'Source custodian code', example: 'paysera'),
        new OA\Property(property: 'to_custodian', type: 'string', description: 'Destination custodian code', example: 'deutsche_bank'),
        new OA\Property(property: 'amount', type: 'integer', description: 'Amount in cents', example: 100000),
        new OA\Property(property: 'currency', type: 'string', example: 'EUR'),
        new OA\Property(property: 'reference', type: 'string', example: 'Settlement-2025-001'),
        new OA\Property(property: 'urgency', type: 'string', enum: ['normal', 'urgent', 'instant'], example: 'normal'),
        new OA\Property(property: 'metadata', type: 'object', description: 'Additional transfer data'),
    ],
)]
#[OA\Schema(
    schema: 'CustodianReconciliation',
    required: ['id', 'custodian_code', 'reconciliation_date', 'status', 'discrepancies'],
    properties: [
        new OA\Property(property: 'id', type: 'string', format: 'uuid'),
        new OA\Property(property: 'custodian_code', type: 'string', example: 'revolut'),
        new OA\Property(property: 'reconciliation_date', type: 'string', format: 'date', example: '2025-01-15'),
        new OA\Property(property: 'status', type: 'string', enum: ['pending', 'in_progress', 'completed', 'failed'], example: 'completed'),
        new OA\Property(
            property: 'internal_balance',
            type: 'object',
            properties: [
                new OA\Property(property: 'EUR', type: 'integer', example: 5000000),
                new OA\Property(property: 'USD', type: 'integer', example: 2000000),
            ],
        ),
        new OA\Property(
            property: 'custodian_balance',
            type: 'object',
            properties: [
                new OA\Property(property: 'EUR', type: 'integer', example: 5000000),
                new OA\Property(property: 'USD', type: 'integer', example: 1999500),
            ],
        ),
        new OA\Property(
            property: 'discrepancies',
            type: 'array',
            items: new OA\Items(
                properties: [
                    new OA\Property(property: 'currency', type: 'string', example: 'USD'),
                    new OA\Property(property: 'internal_amount', type: 'integer', example: 2000000),
                    new OA\Property(property: 'custodian_amount', type: 'integer', example: 1999500),
                    new OA\Property(property: 'difference', type: 'integer', example: 500),
                    new OA\Property(property: 'explanation', type: 'string', example: 'Pending fee deduction'),
                ],
            ),
        ),
        new OA\Property(
            property: 'transaction_count',
            type: 'object',
            properties: [
                new OA\Property(property: 'internal', type: 'integer', example: 150),
                new OA\Property(property: 'custodian', type: 'integer', example: 150),
            ],
        ),
        new OA\Property(property: 'completed_at', type: 'string', format: 'date-time'),
        new OA\Property(property: 'created_at', type: 'string', format: 'date-time'),
    ],
)]
#[OA\Schema(
    schema: 'CustodianWebhookPayload',
    required: ['event_type', 'custodian_code', 'timestamp', 'data'],
    properties: [
        new OA\Property(property: 'event_type', type: 'string', enum: ['transfer.completed', 'transfer.failed', 'balance.updated', 'account.blocked'], example: 'transfer.completed'),
        new OA\Property(property: 'custodian_code', type: 'string', example: 'n26'),
        new OA\Property(property: 'timestamp', type: 'string', format: 'date-time'),
        new OA\Property(property: 'data', type: 'object', description: 'Event-specific data'),
        new OA\Property(property: 'signature', type: 'string', description: 'HMAC signature for verification', example: 'sha256=abc123...'),
    ],
)]
#[OA\Schema(
    schema: 'CustodianHealthStatus',
    required: ['custodian_code', 'status', 'last_check', 'metrics'],
    properties: [
        new OA\Property(property: 'custodian_code', type: 'string', example: 'paysera'),
        new OA\Property(property: 'status', type: 'string', enum: ['healthy', 'degraded', 'unhealthy'], example: 'healthy'),
        new OA\Property(property: 'last_check', type: 'string', format: 'date-time'),
        new OA\Property(property: 'uptime_percentage', type: 'number', example: 99.95),
        new OA\Property(
            property: 'metrics',
            type: 'object',
            properties: [
                new OA\Property(property: 'response_time_ms', type: 'integer', example: 250),
                new OA\Property(property: 'success_rate', type: 'number', example: 99.8),
                new OA\Property(property: 'error_rate', type: 'number', example: 0.2),
            ],
        ),
        new OA\Property(
            property: 'recent_errors',
            type: 'array',
            items: new OA\Items(
                properties: [
                    new OA\Property(property: 'timestamp', type: 'string', format: 'date-time'),
                    new OA\Property(property: 'error_type', type: 'string', example: 'timeout'),
                    new OA\Property(property: 'message', type: 'string', example: 'API request timeout after 30s'),
                ],
            ),
        ),
        new OA\Property(
            property: 'circuit_breaker',
            type: 'object',
            properties: [
                new OA\Property(property: 'state', type: 'string', enum: ['closed', 'open', 'half_open'], example: 'closed'),
                new OA\Property(property: 'failure_count', type: 'integer', example: 0),
                new OA\Property(property: 'last_failure', type: 'string', format: 'date-time'),
            ],
        ),
    ],
)]
#[OA\Schema(
    schema: 'CustodianSettlement',
    required: ['id', 'settlement_date', 'status', 'total_amount', 'transactions'],
    properties: [
        new OA\Property(property: 'id', type: 'string', format: 'uuid'),
        new OA\Property(property: 'settlement_date', type: 'string', format: 'date', example: '2025-01-15'),
        new OA\Property(property: 'status', type: 'string', enum: ['pending', 'processing', 'completed', 'failed'], example: 'completed'),
        new OA\Property(
            property: 'total_amount',
            type: 'object',
            properties: [
                new OA\Property(property: 'EUR', type: 'integer', example: 1000000),
                new OA\Property(property: 'USD', type: 'integer', example: 500000),
            ],
        ),
        new OA\Property(
            property: 'transactions',
            type: 'array',
            items: new OA\Items(
                properties: [
                    new OA\Property(property: 'from_custodian', type: 'string', example: 'paysera'),
                    new OA\Property(property: 'to_custodian', type: 'string', example: 'deutsche_bank'),
                    new OA\Property(property: 'amount', type: 'integer', example: 250000),
                    new OA\Property(property: 'currency', type: 'string', example: 'EUR'),
                    new OA\Property(property: 'type', type: 'string', enum: ['net', 'gross'], example: 'net'),
                ],
            ),
        ),
        new OA\Property(property: 'settlement_method', type: 'string', enum: ['net', 'gross', 'batch'], example: 'net'),
        new OA\Property(property: 'executed_at', type: 'string', format: 'date-time'),
        new OA\Property(property: 'created_at', type: 'string', format: 'date-time'),
    ],
)]
class CustodianSchemas
{
    // This class only contains OpenAPI schema definitions
}
