<?php

declare(strict_types=1);

namespace App\Domain\Custodian\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ReconciliationReport extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    /**
     * Create a new message instance.
     */
    public function __construct(
        public array $summary,
        public array $discrepancies
    ) {
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        $subject = $this->summary['discrepancies_found'] > 0
            ? "[ACTION REQUIRED] Daily Reconciliation Report - {$this->summary['date']}"
            : "Daily Reconciliation Report - {$this->summary['date']}";

        return new Envelope(
            subject: $subject,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            markdown: 'emails.reconciliation-report',
            with: [
                'summary'          => $this->summary,
                'discrepancies'    => $this->discrepancies,
                'hasDiscrepancies' => $this->summary['discrepancies_found'] > 0,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
