# v2.6.0 Privacy Layer & ERC-4337 Relayer Implementation

> **Released**: February 2, 2026
> **Theme**: Mobile Backend Privacy Features

---

## Overview

v2.6.0 implements backend APIs required for mobile app privacy features:
- **P0**: Merkle tree sync, Smart account management
- **P1**: Delegated proving, SRS manifest
- **P2**: WebSocket updates, Enhanced relayer, UserOp signing

---

## PRs Merged (8 total)

| PR | Title | Priority |
|----|-------|----------|
| #368 | Merkle Tree Infrastructure | P0 |
| #369 | Smart Account Management | P0 |
| #370 | Delegated Proof Generation | P1 |
| #371 | SRS Manifest Endpoint | P1 |
| #372 | WebSocket Merkle Updates | P2 |
| #373 | Enhanced Relayer Endpoints | P2 |
| #374 | UserOperation Signing | P2 |
| #375 | Security Hardening | N/A |

---

## New API Endpoints

### Privacy Domain
```
GET  /api/v1/privacy/merkle-root          # Current Merkle root
POST /api/v1/privacy/merkle-path          # Path for commitment
GET  /api/v1/privacy/srs-manifest         # ZK circuit parameters
POST /api/v1/privacy/delegated-proof      # Request server-side proof
GET  /api/v1/privacy/delegated-proof/{id} # Check proof status
```

### Relayer Domain
```
POST /api/v1/relayer/account              # Create smart account
GET  /api/v1/relayer/nonce/{address}      # Get account nonce
POST /api/v1/relayer/sponsor              # Sponsor UserOp (enhanced)
GET  /api/v1/relayer/networks             # Network details (enhanced)
```

### Auth Domain
```
POST /api/auth/sign-userop                # Sign UserOp with auth shard
```

---

## Key Services

### Privacy Domain
| Service | Purpose |
|---------|---------|
| `MerkleTreeService` | Privacy pool state sync |
| `DemoMerkleTreeService` | Demo implementation |
| `DelegatedProofService` | Server-side ZK proving |
| `SrsManifestService` | ZK circuit SRS management |

### Relayer Domain
| Service | Purpose |
|---------|---------|
| `SmartAccountService` | ERC-4337 account management |
| `DemoSmartAccountFactory` | Demo account creation |
| `GasStationService` | Gas sponsorship (enhanced with initCode) |
| `UserOperationSigningService` | Auth shard signing |

---

## Security Hardening (PR #375)

1. **Route-level rate limiting**: `throttle:10,1` on sign-userop
2. **Input validation bounds**: device_shard_proof max 260 hex chars
3. **Atomic rate limiting**: `Cache::increment()` for race condition fix
4. **Reduced logging**: Hash hint from 10 to 6 chars

### Production TODOs (Documented)
- HSM integration for ECDSA signing (KeyManagement domain)
- JWT biometric verification with mobile attestation
- Poseidon hash for ZK compatibility (currently SHA3-256)
- On-chain Merkle root consensus verification

---

## Configuration

### config/privacy.php
```php
'merkle' => [
    'sync_interval_seconds' => 30,
    'max_tree_depth' => 32,
    'networks' => ['polygon', 'base', 'arbitrum'],
],
'delegated_proving' => [
    'enabled' => true,
    'max_queue_size' => 100,
    'timeout_seconds' => 300,
],
'srs' => [
    'cdn_base_url' => 'https://cdn.finaegis.com/srs',
    'version' => '1.0.0',
],
```

### config/relayer.php
```php
'smart_accounts' => [
    'factory_addresses' => [
        'polygon' => env('POLYGON_FACTORY_ADDRESS'),
        // ...
    ],
],
```

---

## WebSocket Channels

| Channel | Event | Purpose |
|---------|-------|---------|
| `private-privacy.merkle.{network}` | `merkle.updated` | Tree sync |
| `private-privacy.proof.{userId}` | `proof.progress/completed/failed` | Proof status |

---

## Error Codes

### Privacy Domain (ERR_PRIVACY_3xx)
- `ERR_PRIVACY_306`: Merkle root not found
- `ERR_PRIVACY_307`: Invalid commitment
- `ERR_PRIVACY_308`: Tree sync failed

### Relayer Domain (ERR_RELAYER_1xx, 2xx)
- `ERR_RELAYER_101`: Invalid owner address
- `ERR_RELAYER_102`: Account already exists
- `ERR_RELAYER_103`: Network not supported
- `ERR_RELAYER_201`: Invalid UserOp hash
- `ERR_RELAYER_202`: Invalid device shard proof
- `ERR_RELAYER_203`: Biometric verification failed
- `ERR_RELAYER_204`: Auth shard unavailable
- `ERR_RELAYER_205`: Signing failed

---

## Testing

```bash
# Run v2.6.0 tests
./vendor/bin/pest tests/Unit/Domain/Privacy/
./vendor/bin/pest tests/Unit/Domain/Relayer/
./vendor/bin/pest tests/Feature/Api/Privacy/
./vendor/bin/pest tests/Feature/Api/Relayer/
./vendor/bin/pest tests/Feature/Api/Auth/UserOpSigningControllerTest.php
```

---

## Dependencies

- Requires v2.4.0 Privacy domain foundation
- Requires v2.2.0 Mobile backend infrastructure
- Uses existing KeyManagement for future HSM integration
